<?php
declare(strict_types=1);

require_once __DIR__ . '/_auth.php';
tpcms_require_admin();

require_once __DIR__ . '/../config.php';

?>
<!doctype html>
<html lang="ja">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>管理ダッシュボード｜Template Party CMS</title>
  <link rel="stylesheet" href="./assets/admin.css">
<style>
</style>
</head>
<body class="index">

<header>
<div>
<a href="../" target="_blank" rel="noopener">公開側トップ</a>
</div>
<div>
<a href="./logout.php">ログアウト</a>
</div>
</header>

<div id="container">

    <h1>管理ダッシュボード</h1>
    
    <?php
    $__minPhp = '8.0';  // 推奨バージョン（必要なら変更可）
    $__phpTooLow = function_exists('version_compare') ? version_compare(PHP_VERSION, $__minPhp, '<') : true;
    if ($__phpTooLow): ?>
      <p class="notice">
        <strong style="color: red;">※現在の環境ではCMSが動作しない可能性があります。</strong><br>
        あなたの現在のPHPは<strong style="color: red;"><?= tpcms_h(PHP_VERSION) ?></strong>です。<br>
        正常に動作しない場合はサーバーのコントロールパネルでPHPを最低でも<strong style="color: red;"><?= tpcms_h($__minPhp) ?></strong>（推奨は <strong style="color: red;">8.2〜8.3</strong>）へ切り替えて下さい。<br>
        尚、他にphpを使ったシステムがあるとそちらで不具合が出る可能性が高いので切り替えの際は注意して下さい。
      </p>
    <?php endif; ?>

    <h2>サイト設定</h2>
    <nav aria-label="管理メニュー" class="menu mb3rem">
      <ul>
        <li><a href="./site.php">サイト基本設定</a></li>
        <li><a href="./menu.php">メニュー設定</a></li>
        <li><a href="./news.php">お知らせ設定</a></li>
        <li><a href="./contact_settings.php">フォーム設定</a></li>
        <li><a href="./license.php">ライセンス管理</a></li>
      </ul>
    </nav>

    <!-- ページ別ブロック編集（/data/menu.json を参照） -->
    <?php
      $menuJsonPath = __DIR__ . '/../data/menu.json';
      $items = [];
      if (is_file($menuJsonPath)) {
          $json = file_get_contents($menuJsonPath);
          $data = json_decode($json, true);
          if (!empty($data['items']) && is_array($data['items'])) {
              $items = $data['items'];
          }
      }
      if ($items):
    ?>
    
    <h2>ページ編集</h2>
    <p class="small">上の「メニュー編集」で追加したページがここに表示されます。（先頭が#で始まるアンカーリンクは除く）</p>
    <nav aria-label="ページ別ブロック編集" class="menu">
      <nav class="menu">
        <ul>
          <?php foreach ($items as $row):
            $slug     = isset($row['slug'])     ? (string)$row['slug']     : '';
            $label    = isset($row['label'])    ? (string)$row['label']    : $slug;
            $editable = isset($row['editable']) ? (int)$row['editable']    : 1; // 既定＝編集する
            if ($slug === '') continue;
          ?>
            <?php if ($editable === 1 && !preg_match('~^(?:https?://|#)~i', (string)$slug)): ?>
            <li>
              <a href="./page_blocks.php?page=<?= htmlspecialchars($slug, ENT_QUOTES, 'UTF-8') ?>">
                <?php
                // admin表示では装飾タグは“テキストだけ”を残し、タグ位置は半角スペース化。
                // 1) タグ→スペース 2) HTML実体を復号 3) 連続空白を1つに圧縮 4) 前後trim
                $label_admin = $label;
                $label_admin = preg_replace('#<[^>]*>#u', ' ', $label_admin);           // タグ→スペース
                $label_admin = html_entity_decode($label_admin, ENT_QUOTES, 'UTF-8');   // 実体復号（&amp; ⇒ & など）
                $label_admin = str_replace("\xC2\xA0", ' ', $label_admin);              // NBSP→スペース
                $label_admin = preg_replace('/\s+/u', ' ', $label_admin);               // 空白を1つに
                $label_admin = trim($label_admin);
                ?>
                <?= htmlspecialchars($label_admin, ENT_QUOTES, 'UTF-8') ?> のブロック編集
              </a>
            </li>
            <?php endif; ?>
          <?php endforeach; ?>
        </ul>
      </nav>
    <?php endif; ?>

      <p class="small r" style="margin-top:2rem;">
        <a href="./cleanup_unused_uploads.php?_csrf=<?= tpcms_h(tpcms_csrf_token()) ?>"
           onclick="return confirm('未使用の画像・動画を uploads から一括削除します。\nこの操作は元に戻せません。実行してよろしいですか？');" style="border: none;">
          未使用画像一括削除
        </a>
      </p>

</div>

  <script src="./assets/admin.js"></script>
</body>
</html>
