<?php
declare(strict_types=1);

require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../app/security.php';

tpcms_start_session_secure();
tpcms_send_security_headers();

// --- セッションを完全破棄 ---
$_SESSION = [];
if (ini_get('session.use_cookies')) {
    $p = session_get_cookie_params();
    // 既存クッキーを即時失効（パス/ドメイン/セキュア/HttpOnly を現状に合わせる）
    setcookie(
        session_name(),
        '',
        time() - 42000,
        $p['path'] ?? '/',
        $p['domain'] ?? '',
        tpcms_is_https(),
        true
    );
}
@session_destroy();

// 念のための最小待避（URL直叩き時の再入場を避ける）
header('Location: ./login.php');
exit;
