// Smooth-scroll for same-page links that use "./#anchor"
(function () {
  function sameDoc(u) {
    var a = document.createElement('a');
    a.href = u;
    var cur = window.location;
    var norm = function (p) { return p.replace(/\/+$/,''); }; // trim trailing slash
    return a.origin === cur.origin && norm(a.pathname) === norm(cur.pathname);
  }

  document.addEventListener('click', function (e) {
    var link = e.target && e.target.closest && e.target.closest('a[href^="./#"]');
    if (!link) return;

    var url = new URL(link.getAttribute('href'), window.location.href);
    if (!sameDoc(url.href)) return; // only hijack same-document jumps

    var id = decodeURIComponent((url.hash || '').slice(1));
    if (!id) return;

    var target = document.getElementById(id) ||
                 document.querySelector('[name="'+ (window.CSS && CSS.supports && CSS.supports('selector(:is(*))') && CSS.escape ? CSS.escape(id) : id) +'"]');
    if (!target) return;

    e.preventDefault();

    // Adjust if you have a fixed header (e.g., const offset = document.querySelector('.l-header')?.offsetHeight || 0;)
    var offset = 0;
    var top = target.getBoundingClientRect().top + window.pageYOffset - offset;

    window.scrollTo({ top: top, behavior: 'smooth' });
    try { history.replaceState(null, '', '#' + encodeURIComponent(id)); } catch (_) {}
  }, { capture: true });
})();


//===============================================================
// 詳細ページのサムネイル切り替え（画像/動画 両対応）
//===============================================================
$(function() {
  // サムネvideoはコントロールを無効化して再生させない（クリックを親で拾うため）
  $('.thumbnail-parts video').each(function() {
    this.removeAttribute('controls'); try { this.pause(); this.currentTime = 0; } catch(e) {}
  });

  // 動画サムネに“再生アイコン”を重ねる（Font Awesome 利用）
  $('.thumbnail-parts video').each(function() {
    var $v = $(this);
    if (!$v.parent().hasClass('thumb-wrap')) {
      $v.wrap('<span class="thumb-wrap is-video"></span>');
      // FA6/FA5両対応クラス
      $v.after('<span class="thumb-play" aria-hidden="true"><i class="fa-solid fa-play fas fa-play"></i></span>');
    }
  });

  // サムネ要素（img, video）から、表示用の要素を生成
  function createViewerEl($media) {
    if ($media.is('img')) {
      return $('<img>').attr('src', $media.attr('src'));
    }
    if ($media.is('video')) {
      // <video src> 形式も <video><source></video> 形式も拾う
      var src = $media.attr('src') || $media.find('source:first').attr('src');
      if (!src) return null;
      return $('<video>')
        .attr({ src: src, controls: true, playsinline: true, preload: 'metadata' });
    }
    return null;
  }

  // 初期表示：直後の .thumbnail-parts の最初の「img か video」を表示
  $('.thumbnail-view-parts').each(function() {
    var $view = $(this);
    var $first = $view.next('.thumbnail-parts').find('img,video').first();
    var $el = createViewerEl($first);
    if ($el) $view.empty().append($el);
  });

  // サムネイル側クリック（委譲はコンテナに付与）
  $('.thumbnail-parts').on('pointerdown', function(e) {
    // クリック位置から、このコンテナ内の img / video を特定
    var $media = $(e.target).closest('img,video', this);
    if (!$media.length) return;
    e.preventDefault();

    // サムネ video の再生を止めておく（誤再生防止）
    if ($media.is('video') && $media[0].pause) $media[0].pause();

    var $targetView = $(this).prev('.thumbnail-view-parts');
    var $nextEl = createViewerEl($media);
    if (!$nextEl) return;

    $nextEl.hide();
    $targetView.find('img,video').fadeOut(400, function() {
      $targetView.empty().append($nextEl);
      $nextEl.fadeIn(400);
    });
  });
});
