// Smooth-scroll for same-page links that use "./#anchor"
(function () {
  function sameDoc(u) {
    var a = document.createElement('a');
    a.href = u;
    var cur = window.location;
    var norm = function (p) { return p.replace(/\/+$/,''); }; // trim trailing slash
    return a.origin === cur.origin && norm(a.pathname) === norm(cur.pathname);
  }

  document.addEventListener('click', function (e) {
    var link = e.target && e.target.closest && e.target.closest('a[href^="./#"]');
    if (!link) return;

    var url = new URL(link.getAttribute('href'), window.location.href);
    if (!sameDoc(url.href)) return; // only hijack same-document jumps

    var id = decodeURIComponent((url.hash || '').slice(1));
    if (!id) return;

    var target = document.getElementById(id) ||
                 document.querySelector('[name="'+ (window.CSS && CSS.supports && CSS.supports('selector(:is(*))') && CSS.escape ? CSS.escape(id) : id) +'"]');
    if (!target) return;

    e.preventDefault();

    // Adjust if you have a fixed header (e.g., const offset = document.querySelector('.l-header')?.offsetHeight || 0;)
    var offset = 0;
    var top = target.getBoundingClientRect().top + window.pageYOffset - offset;

    window.scrollTo({ top: top, behavior: 'smooth' });
    try { history.replaceState(null, '', '#' + encodeURIComponent(id)); } catch (_) {}
  }, { capture: true });
})();


/*以下biz61専用*/

//===============================================================
// スライドショー
//===============================================================
$(function() {
    $('.slide3-parts').each(function() {
        var $this = $(this);
        var slides = $this.find('.slide-parts'); // クラス名を修正
        var slideCount = slides.length;
        var currentIndex = 0;

        // インジケータを表示する要素を取得
        var indicators = $this.find('.slide-indicators'); // クラス名は変更なし

        // スライドの数に応じたインジケータを生成
        for (var i = 0; i < slideCount; i++) {
            indicators.append('<span class="indicator" data-index="' + i + '"></span>');
        }

        // インジケータの初期状態を設定
        var indicatorElements = indicators.find('.indicator');
        indicatorElements.eq(currentIndex).addClass('active');

        // スライドの初期状態を設定
        slides.eq(currentIndex).css('opacity', 1).addClass('active');

        // インジケータをクリックしたときの動作を設定
        indicatorElements.on('click', function() {
            var clickedIndex = $(this).data('index');

            // 現在のスライドと同じ場合は何もしない
            if (clickedIndex === currentIndex) return;

            // スライドの切り替え
            slides.eq(currentIndex).css('opacity', 0).removeClass('active');
            slides.eq(clickedIndex).css('opacity', 1).addClass('active');

            // インジケータの更新
            indicatorElements.eq(currentIndex).removeClass('active');
            indicatorElements.eq(clickedIndex).addClass('active');

            // 現在のスライドを更新
            currentIndex = clickedIndex;
        });

        // 自動スライドのタイマー
        setInterval(function() {
            var nextIndex = (currentIndex + 1) % slideCount;

            // スライドの切り替え
            slides.eq(currentIndex).css('opacity', 0).removeClass('active');
            slides.eq(nextIndex).css('opacity', 1).addClass('active');

            // インジケータの更新
            indicatorElements.eq(currentIndex).removeClass('active');
            indicatorElements.eq(nextIndex).addClass('active');

            currentIndex = nextIndex;
        }, 5000); // 5秒ごとにスライドを切り替える
    });
});


//===============================================================
// 詳細ページのサムネイル切り替え（画像/動画 両対応）
//===============================================================
$(function() {
  // サムネvideoはコントロールを無効化して再生させない（クリックを親で拾うため）
  $('.thumbnail-parts video').each(function() {
    this.removeAttribute('controls'); try { this.pause(); this.currentTime = 0; } catch(e) {}
  });

  // 動画サムネに“再生アイコン”を重ねる（Font Awesome 利用）
  $('.thumbnail-parts video').each(function() {
    var $v = $(this);
    if (!$v.parent().hasClass('thumb-wrap')) {
      $v.wrap('<span class="thumb-wrap is-video"></span>');
      // FA6/FA5両対応クラス
      $v.after('<span class="thumb-play" aria-hidden="true"><i class="fa-solid fa-play fas fa-play"></i></span>');
    }
  });

  // サムネ要素（img, video）から、表示用の要素を生成
  function createViewerEl($media) {
    if ($media.is('img')) {
      return $('<img>').attr('src', $media.attr('src'));
    }
    if ($media.is('video')) {
      // <video src> 形式も <video><source></video> 形式も拾う
      var src = $media.attr('src') || $media.find('source:first').attr('src');
      if (!src) return null;
      return $('<video>')
        .attr({ src: src, controls: true, playsinline: true, preload: 'metadata' });
    }
    return null;
  }

  // 初期表示：直後の .thumbnail-parts の最初の「img か video」を表示
  $('.thumbnail-view-parts').each(function() {
    var $view = $(this);
    var $first = $view.next('.thumbnail-parts').find('img,video').first();
    var $el = createViewerEl($first);
    if ($el) $view.empty().append($el);
  });

  // サムネイル側クリック（委譲はコンテナに付与）
  $('.thumbnail-parts').on('pointerdown', function(e) {
    // クリック位置から、このコンテナ内の img / video を特定
    var $media = $(e.target).closest('img,video', this);
    if (!$media.length) return;
    e.preventDefault();

    // サムネ video の再生を止めておく（誤再生防止）
    if ($media.is('video') && $media[0].pause) $media[0].pause();

    var $targetView = $(this).prev('.thumbnail-view-parts');
    var $nextEl = createViewerEl($media);
    if (!$nextEl) return;

    $nextEl.hide();
    $targetView.find('img,video').fadeOut(400, function() {
      $targetView.empty().append($nextEl);
      $nextEl.fadeIn(400);
    });
  });
});
