<?php
declare(strict_types=1);

require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../app/security.php';

// 全管理ページ共通：セッション開始＋軽量セキュリティヘッダ
tpcms_start_session_secure();
tpcms_send_security_headers();
tpcms_send_nocache_headers();

/**
 * 管理ページ入場ガード：
 * - admin.json が無ければ初回セットアップへ
 * - 未ログインなら login.php へ（next 付き）
 * - アイドルタイムアウト：60分
 */
function tpcms_require_admin(): void {
    $adminFile = __DIR__ . '/../data/admin.json';

    // admin.json 未作成 → セットアップへ
    if (!is_file($adminFile)) {
        header('Location: ./setup_admin.php');
        exit;
    }

    // アイドルタイムアウト（60分）
    $now = time();
    $idleLimit = 60 * 60;
    if (!empty($_SESSION['last_activity']) && ($now - (int)$_SESSION['last_activity']) > $idleLimit) {
        $_SESSION = [];
        if (ini_get('session.use_cookies')) {
            $p = session_get_cookie_params();
            setcookie(session_name(), '', time() - 42000, $p['path'], $p['domain'], $p['secure'], $p['httponly']);
        }
        @session_destroy();
        header('Location: ./login.php');
        exit;
    }
    $_SESSION['last_activity'] = $now;

    // 未ログイン → login.php へ（next で元URL復帰）
    if (empty($_SESSION['admin_logged_in'])) {
        $req = (string)($_SERVER['REQUEST_URI'] ?? './index.php');
        header('Location: ./login.php?next=' . rawurlencode($req));
        exit;
    }
}
