<?php
declare(strict_types=1);
if (!defined('TPCMS_ROOT')) define('TPCMS_ROOT', __DIR__);

/* ---------- パス定数（ドキュメントルート直下 前提） ---------- */
define('TPCMS_APP',     __DIR__ . '/app');
define('TPCMS_DATA',    TPCMS_ROOT . '/data');
define('TPCMS_THEMES',  TPCMS_ROOT . '/themes');
define('TPCMS_UPLOADS', TPCMS_ROOT . '/uploads');

mb_internal_encoding('UTF-8');

/* ---------- 共通ヘルパー ---------- */
function tpcms_h(?string $s): string {
    return htmlspecialchars($s ?? '', ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8');
}

function tpcms_load_json(string $path): array {
    if (!is_file($path)) return [];
    $raw = @file_get_contents($path);
    if ($raw === false) return [];
    $data = json_decode($raw, true);
    return is_array($data) ? $data : [];
}

/**
 * 使用中テーマを取得
 * return: ['theme'=>'beginner9','color'=>'white','base'=>'/abs/path/to/themes/...']
 */
function tpcms_active_theme(): array {
    $a = tpcms_load_json(TPCMS_THEMES . '/_active.json');

    $theme = (isset($a['theme']) && is_string($a['theme']) && $a['theme'] !== '')
        ? $a['theme'] : 'beginner9';

    $color = (isset($a['color']) && is_string($a['color']) && $a['color'] !== '')
        ? $a['color'] : 'white';

    // ① 誤って "biz63_yellow1" のように theme名_が混入していたら除去
    if (strpos($color, $theme . '_') === 0) {
        $color = substr($color, strlen($theme) + 1);
    }

    // ② 実ディレクトリ存在チェック＆自動補正
    $base = TPCMS_THEMES . '/' . $theme . '/' . $color;
    if (!is_dir($base)) {
        // よくある既定色の候補
        $fallbacks = ['yellow1', 'white'];
        foreach ($fallbacks as $fb) {
            if (is_dir(TPCMS_THEMES . '/' . $theme . '/' . $fb)) {
                $color = $fb;
                $base  = TPCMS_THEMES . '/' . $theme . '/' . $color;
                break;
            }
        }
        // それでも無ければ最初に見つかったサブディレクトリを採用
        if (!is_dir($base)) {
            $dir = TPCMS_THEMES . '/' . $theme;
            if (is_dir($dir)) {
                foreach (scandir($dir) ?: [] as $d) {
                    if ($d === '.' || $d === '..') continue;
                    if (is_dir($dir . '/' . $d)) {
                        $color = $d;
                        $base  = $dir . '/' . $color;
                        break;
                    }
                }
            }
        }
    }

    return ['theme' => $theme, 'color' => $color, 'base' => $base];
}

/* ---------- 種別判定（最小） ---------- */
function tpcms_is_video(string $filename): bool {
    $ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
    return in_array($ext, ['mp4', 'webm'], true);
}
function tpcms_is_image(string $filename): bool {
    $ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
    return in_array($ext, ['jpg','jpeg','png','gif','webp','svg'], true);
}
