<?php
declare(strict_types=1);

require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../app/security.php';

tpcms_start_session_secure();
tpcms_send_security_headers();

$adminFile = __DIR__ . '/../data/admin.json';

// 管理者未登録なら初回セットアップへ
if (!is_file($adminFile)) {
    header('Location: ./setup_admin.php');
    exit;
}

// すでにログイン済みなら管理トップへ
if (!empty($_SESSION['admin_logged_in'])) {
    header('Location: ./index.php');
    exit;
}

$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // CSRF
    if (function_exists('tpcms_require_post_csrf')) { tpcms_require_post_csrf(); }

    // ---- ここから 失敗回数レート制限（IPごと：5回/15分）----
    $rateFile  = TPCMS_DATA . '/_rate_login.json';
    $ip        = $_SERVER['REMOTE_ADDR'] ?? 'unknown';
    $now       = time();
    $windowSec = 15 * 60;
    $maxFails  = 5;

    $rate = (is_file($rateFile) ? json_decode((string)@file_get_contents($rateFile), true) : []);
    if (!is_array($rate)) $rate = [];
    $bucket = $rate[$ip] ?? [];
    // 古い記録を間引き
    $bucket = array_values(array_filter($bucket, function ($t) use ($now, $windowSec) {
        return is_int($t) && ($t > $now - $windowSec);
    }));
    // ロック中？
    if (count($bucket) >= $maxFails) {
        $rem = max(0, ($bucket[0] + $windowSec) - $now);
        $mins = (int)ceil($rem / 60);
        $error = 'ログイン失敗が続いたため、一時的にロックされています。約' . $mins . '分後にお試しください。';
    } else {
        // 通常の認証処理
        $email = trim((string)($_POST['email'] ?? $_POST['mail'] ?? ''));
        $pass  = (string)($_POST['password'] ?? $_POST['pass'] ?? '');

        $admin = (is_file(TPCMS_DATA . '/admin.json') ? json_decode((string)@file_get_contents(TPCMS_DATA . '/admin.json'), true) : null);
        $ok = is_array($admin)
            && isset($admin['email'], $admin['password_hash'])
            && (strcasecmp((string)$admin['email'], $email) === 0)
            && password_verify($pass, (string)$admin['password_hash']);

        if ($ok) {
            $_SESSION['admin_logged_in'] = true;
            $_SESSION['admin_user']      = (string)$admin['email'];
            if (function_exists('tpcms_session_regenerate_on_login')) { tpcms_session_regenerate_on_login(); }
            // 成功したら失敗カウントをクリア
            if (isset($rate[$ip])) {
                unset($rate[$ip]);
                @file_put_contents($rateFile, json_encode($rate, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES), LOCK_EX);
                @chmod($rateFile, 0660);
            }
            $next = (string)($_POST['next'] ?? '');
            if (is_string($next) && strpos($next, '/admin/') === 0) {
                header('Location: ' . $next);
            } else {
                header('Location: ./index.php');
            }
            exit;
        } else {
            // 失敗を記録
            $bucket[]   = $now;
            $rate[$ip]  = $bucket;
            @file_put_contents($rateFile, json_encode($rate, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES), LOCK_EX);
            @chmod($rateFile, 0660);
            $error = 'メールアドレスまたはパスワードが正しくありません。';
        }
    }
}

$next  = (string)($_GET['next'] ?? './index.php');
$token = tpcms_csrf_token();
?>
<!doctype html>
<html lang="ja">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>管理ログイン｜Template Party CMS</title>
  <link rel="stylesheet" href="./assets/admin.css">
</head>
<body class="login">

<div id="container">

  <h1>管理ログイン</h1>

  <?php if ($error): ?>
    <p class="error"><?= tpcms_h($error) ?></p>
  <?php endif; ?>

  <form method="post" action="./login.php">
    <input type="hidden" name="_csrf" value="<?= tpcms_h($token) ?>">
    <input type="hidden" name="next" value="<?= tpcms_h($next) ?>">

    <p>
      <label>メールアドレス
        <input type="email" name="email" required>
      </label>
    </p>
    <p>
      <label>パスワード
        <input type="password" name="pass" required>
      </label>
    </p>
    <p><button type="submit" class="btn1">ログイン</button></p>
  </form>

</div>

</body>
</html>
