//===============================================================
// 詳細ページのサムネイル切り替え（画像/動画 両対応）
//===============================================================
$(function() {
  // サムネvideoはコントロールを無効化して再生させない（クリックを親で拾うため）
  $('.thumbnail-parts video').each(function() {
    this.removeAttribute('controls'); try { this.pause(); this.currentTime = 0; } catch(e) {}
  });

  // 動画サムネに“再生アイコン”を重ねる（Font Awesome 利用）
  $('.thumbnail-parts video').each(function() {
    var $v = $(this);
    if (!$v.parent().hasClass('thumb-wrap')) {
      $v.wrap('<span class="thumb-wrap is-video"></span>');
      // FA6/FA5両対応クラス
      $v.after('<span class="thumb-play" aria-hidden="true"><i class="fa-solid fa-play fas fa-play"></i></span>');
    }
  });

  // サムネ要素（img, video）から、表示用の要素を生成
  function createViewerEl($media) {
    if ($media.is('img')) {
      return $('<img>').attr('src', $media.attr('src'));
    }
    if ($media.is('video')) {
      // <video src> 形式も <video><source></video> 形式も拾う
      var src = $media.attr('src') || $media.find('source:first').attr('src');
      if (!src) return null;
      return $('<video>')
        .attr({ src: src, controls: true, playsinline: true, preload: 'metadata' });
    }
    return null;
  }

  // 初期表示：直後の .thumbnail-parts の最初の「img か video」を表示
  $('.thumbnail-view-parts').each(function() {
    var $view = $(this);
    var $first = $view.next('.thumbnail-parts').find('img,video').first();
    var $el = createViewerEl($first);
    if ($el) $view.empty().append($el);
  });

  // サムネイル側クリック（委譲はコンテナに付与）
  $('.thumbnail-parts').on('pointerdown', function(e) {
    // クリック位置から、このコンテナ内の img / video を特定
    var $media = $(e.target).closest('img,video', this);
    if (!$media.length) return;
    e.preventDefault();

    // サムネ video の再生を止めておく（誤再生防止）
    if ($media.is('video') && $media[0].pause) $media[0].pause();

    var $targetView = $(this).prev('.thumbnail-view-parts');
    var $nextEl = createViewerEl($media);
    if (!$nextEl) return;

    $nextEl.hide();
    $targetView.find('img,video').fadeOut(400, function() {
      $targetView.empty().append($nextEl);
      $nextEl.fadeIn(400);
    });
  });
});


//===============================================================
// 画面幅1000px未満でclassの付け外し
//===============================================================
$(function () {
  const mq = window.matchMedia('(max-width: 1000px)');
  const apply = () => {
    $('.list-tpcms-grid').toggleClass('window-s', mq.matches);
  };
  apply(); // 初期適用
  if (mq.addEventListener) {
    mq.addEventListener('change', apply);
  } else {
    mq.addListener(apply); // 古いブラウザ向け
  }
});


//===============================================================
// 横スライドインタイプのスライドショー
//===============================================================
$(function() {
    $('.slide5-parts').each(function() {
        var $this = $(this);
        var slides = $this.find('.slide-parts');
        var slideCount = slides.length;
        var currentIndex = 0;
        var isAnimating = false;

        // インジケータを表示する要素を取得
        var indicators = $this.find('.slide-indicators-parts');

        // スライドの数に応じたインジケータを生成
        for (var i = 0; i < slideCount; i++) {
            indicators.append('<span class="indicator" data-index="' + i + '"></span>');
        }

        // インジケータの初期状態を設定
        var indicatorElements = indicators.find('.indicator');
        indicatorElements.eq(currentIndex).addClass('active');

        // 初期状態で全てのスライドに .hidden クラスを追加
        slides.addClass('hidden');

        // 最初のスライドに .active と .initial クラスを追加し、.hidden クラスを削除
        slides.eq(currentIndex).addClass('active initial').removeClass('hidden');

        // 遅延後に .initial クラスを削除
        setTimeout(function() {
            slides.eq(currentIndex).removeClass('initial');
        }, 50);

        // インジケータをクリックしたときの動作を設定
        indicatorElements.on('click', function() {
            var clickedIndex = $(this).data('index');

            // アニメーション中は操作を受け付けない
            if (isAnimating) return;

            // 現在のスライドと同じ場合は何もしない
            if (clickedIndex === currentIndex) return;

            // スライドの切り替え
            changeSlide(clickedIndex);
        });

        // 自動スライドのタイマー
        setInterval(function() {
            var nextIndex = (currentIndex + 1) % slideCount;
            changeSlide(nextIndex);
        }, 4000); // 4秒ごとにスライドを切り替える

        function changeSlide(nextIndex) {
            isAnimating = true;

            // 現在のスライドを左に移動
            slides.eq(currentIndex).removeClass('active').addClass('left');

            // 次のスライドを表示
            slides.eq(nextIndex).addClass('active').removeClass('hidden');

            // インジケータの更新
            indicatorElements.eq(currentIndex).removeClass('active');
            indicatorElements.eq(nextIndex).addClass('active');

            // アニメーション終了後の処理
            setTimeout(function() {
                // 左に移動したスライドに .hidden クラスを追加
                slides.eq(currentIndex).removeClass('left').addClass('hidden');

                currentIndex = nextIndex;
                isAnimating = false;
            }, 700); // cssの「.slide5-parts .slide-parts」の行の時間と合わせる
        }
    });
});
