<?php
declare(strict_types=1);

require_once __DIR__ . '/../helpers.php';
require_once __DIR__ . '/../auth/_auth.php';

// ログアウト（セッション情報を破棄してID再発行）
auth_logout();

// 戻り先（任意）。?return= が安全なら引き継ぎ、未指定なら /admin/ をデフォルトに
$raw = $_GET['return'] ?? '';
$raw = is_string($raw) ? $raw : '';
$base = (defined('BASE_PATH') && BASE_PATH !== '/') ? BASE_PATH : '';
$ok = ($raw !== '' && !preg_match('~^[a-z][a-z0-9+.\-]*://~i', $raw) && str_starts_with($raw, ($base === '' ? '/' : $base . '/')));
$to = $ok ? $raw : '/admin/';

// ログイン画面へ
header('Location: ' . url_for('/admin/login.php', ['return' => $to]), true, 302);
exit;
