<?php
declare(strict_types=1);

require_once __DIR__ . '/../app/macro_light.php';

// 表示したいテンプレ名を ?p=faq のように受け取る（英数/_/- のみ許可）
$p = isset($_GET['p']) ? (string)$_GET['p'] : '';
$p = preg_replace('~[^A-Za-z0-9_\-]+~', '', $p);
if ($p === '') {
    // 省略時のデフォルト（必要に応じて変更OK）
    $p = 'index';
}

$tplPath = tpcms_templates_dir() . '/' . $p . '.html';

// 存在チェック → 404
if (!is_file($tplPath)) {
    http_response_code(404);
    header('Content-Type: text/html; charset=UTF-8');
    echo '<!doctype html><meta charset="utf-8"><title>404 Not Found</title>'
       . '<p>ページが見つかりません：templates/' . htmlspecialchars($p, ENT_QUOTES, 'UTF-8') . '.html</p>';
    exit;
}

// 読み込み → ライト版レンダラを通す
$html = (string)file_get_contents($tplPath);
$out  = tpcms_render_light($html);

// 出力
header('Content-Type: text/html; charset=UTF-8');
echo $out;
