<?php
declare(strict_types=1);

require_once __DIR__ . '/../app/macro.php';

// コンテキスト（GETをそのまま）
$category = preg_replace('~[^A-Za-z0-9_\-]+~', '', (string)($_GET['category'] ?? ''));
$ctx = [
    'category' => $category,
    'query'    => $_GET, // q, sort, dir, page, per
];

// テンプレHTMLの場所（ユーザーが編集するのはこの .html）
$tplPath = tpcms_templates_dir() . '/list.html';

// 読み込み（無ければフォールバック）
if (is_file($tplPath)) {
    $html = (string)file_get_contents($tplPath);
} else {
    // フォールバック：最小UI（後で /templates/list.html を作れば置き換わります）
    $css = h(asset_url('/admin/assets/admin.css', true));
    $html = <<<HTML
<!doctype html>
<html lang="ja">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>一覧｜tpcms</title>
  <link rel="stylesheet" href="{$css}">
  <style>
    .tpcms-list.cards{display:grid;grid-template-columns:repeat(auto-fill,minmax(260px,1fr));gap:1rem}
    .tpcms-list .card{border:1px solid #ddd;padding:1rem}
    .tpcms-list .card-media img,.tpcms-list .card-media video{width:100%;height:auto;display:block}
    .tpcms-pager{display:flex;gap:.5rem;justify-content:center;margin:2rem 0}
    .tpcms-pager a,.tpcms-pager span{padding:.4rem .6rem;border:1px solid #ddd}
    form.tpcms-search{margin:1rem 0;display:flex;gap:.5rem}
  </style>
</head>
<body>
  <main class="container">
    <h1>一覧</h1>
    {{SEARCH_FORM id="basic"}}
    {{LIST card="A"}}
    {{PAGER}}
  </main>
</body>
</html>
HTML;
}

// プレースホルダーを置換して出力
echo macro_render($html, $ctx);
