<?php
declare(strict_types=1);

require_once __DIR__ . '/app/macro.php';

// ホームはカテゴリ未指定が基本。GETはそのまま次工程の拡張で活用する想定
$category = preg_replace('~[^A-Za-z0-9_\-]+~', '', (string)($_GET['category'] ?? ''));
$ctx = [
    'category' => $category,
    'query'    => $_GET, // 将来：q/sort/dir などを保持するため
];

// ユーザー編集用テンプレ
$tplPath = tpcms_templates_dir() . '/home.html';

// 読み込み（無ければフォールバック）
if (is_file($tplPath)) {
    $html = (string)file_get_contents($tplPath);
} else {
    $css = h(asset_url('/admin/assets/admin.css', true));
    $html = <<<HTML
<!doctype html>
<html lang="ja">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>ホーム｜tpcms</title>
  <link rel="stylesheet" href="{$css}">
  <style>
    main.container{max-width:980px;margin:2rem auto;padding:0 1rem}
    form.tpcms-search{margin:1rem 0;display:flex;gap:.5rem;flex-wrap:wrap}
  </style>
</head>
<body>
  <main class="container">
    <h1>ホーム（仮）</h1>
    <p>templates/home.html を作成すると、この画面は置き換わります。</p>
    {{SEARCH_FORM id="basic"}}
  </main>
</body>
</html>
HTML;
}

echo macro_render($html, $ctx);
