//===============================================================
// 詳細ページのサムネイル切り替え（画像/動画 両対応）
//===============================================================
$(function() {

  // サムネvideoの初期設定（コントロール無効化、iOS対策、再生アイコン追加）
  $('.thumbnail-parts video').each(function() {
    var $v = $(this);
    var videoEl = this; // DOM要素そのもの

    // --- 1. iOS対策と属性設定 ---
    $v.attr({
      'preload': 'metadata', // 最初のフレーム情報を読み込む
      'muted': true,         // iOSで制御を受け付けさせるため消音
      'playsinline': true    // インライン再生を許可
    });
    
    videoEl.removeAttribute('controls'); // コントロールバーを消す

    // --- 2. 停止位置の調整 ---
    try {
      videoEl.pause();
      // iOSは0秒だと描画されないことがあるため、0.1秒地点を表示させる
      videoEl.currentTime = 0.1; 
    } catch(e) {}

    // --- 3. 再生アイコンの追加（まだラップされていなければ） ---
    if (!$v.parent().hasClass('thumb-wrap')) {
      $v.wrap('<span class="thumb-wrap is-video"></span>');
      // FA6/FA5両対応クラス
      $v.after('<span class="thumb-play" aria-hidden="true"><i class="fa-solid fa-play fas fa-play"></i></span>');
    }
  });
  
  // サムネ要素（img, video）から、表示用の要素を生成
  function createViewerEl($media) {
    if ($media.is('img')) {
      return $('<img>').attr('src', $media.attr('src'));
    }
    if ($media.is('video')) {
      // <video src> 形式も <video><source></video> 形式も拾う
      var src = $media.attr('src') || $media.find('source:first').attr('src');
      if (!src) return null;
      return $('<video>')
        .attr({ src: src, controls: true, playsinline: true, preload: 'metadata' });
    }
    return null;
  }

  // 初期表示：直後の .thumbnail の最初の「img か video」を表示
  $('.thumbnail-view-parts').each(function() {
    var $view = $(this);
    var $first = $view.next('.thumbnail-parts').find('img,video').first();
    var $el = createViewerEl($first);
    if ($el) $view.empty().append($el);
  });

  // サムネイル側クリック（委譲はコンテナに付与）
  $('.thumbnail-parts').on('pointerdown', function(e) {
    // クリック位置から、このコンテナ内の img / video を特定
    var $media = $(e.target).closest('img,video', this);
    if (!$media.length) return;
    e.preventDefault();

    // サムネ video の再生を止めておく（誤再生防止）
    if ($media.is('video') && $media[0].pause) $media[0].pause();

    var $targetView = $(this).prev('.thumbnail-view-parts');
    var $nextEl = createViewerEl($media);
    if (!$nextEl) return;

    $nextEl.hide();
    $targetView.find('img,video').fadeOut(400, function() {
      $targetView.empty().append($nextEl);
      $nextEl.fadeIn(400);
    });
  });
});


//===============================================================
// 画面幅1000px未満でclassの付け外し
//===============================================================
$(function () {
  const mq = window.matchMedia('(max-width: 1000px)');
  const apply = () => {
    $('.list-tpcms-grid').toggleClass('window-s', mq.matches);
  };
  apply(); // 初期適用
  if (mq.addEventListener) {
    mq.addEventListener('change', apply);
  } else {
    mq.addListener(apply); // 古いブラウザ向け
  }
});
