<?php
declare(strict_types=1);

require_once __DIR__ . '/../helpers.php';
require_once __DIR__ . '/../auth/_auth.php';
require_once __DIR__ . '/../security/_csrf.php';

// 未ログインならログインへ
auth_require_login();

require_once __DIR__ . '/../app/categories.php';

$id  = (int)($_GET['id'] ?? 0);
$err = '';
$row = null;

if ($id > 0) {
  $row = tpcms_cat_find_by_id($id);
  if (!$row) {
    $err = '指定のカテゴリが見つかりません。';
  }
} else {
  $err = 'IDが不正です。';
}

if (($_SERVER['REQUEST_METHOD'] ?? '') === 'POST' && (string)($_POST['_action'] ?? '') === 'update') {
  csrf_check_or_die();
  $name      = trim((string)($_POST['name'] ?? ''));
  $slug      = trim((string)($_POST['slug'] ?? ''));
  $is_active = isset($_POST['is_active']);

  try {
    tpcms_cat_update($id, $name, $slug, $is_active);
    header('Location: ./categories.php?updated=1');
    exit;
  } catch (Throwable $e) {
    $msg = $e->getMessage();
    if ($e instanceof PDOException && $e->getCode() === '23000') {
      $err = 'このスラッグは既に使用されています。別のスラッグを指定してください。';
    } elseif (stripos($msg, 'UNIQUE') !== false && stripos($msg, 'slug') !== false) {
      $err = 'このスラッグは既に使用されています。別のスラッグを指定してください。';
    } else {
      $err = $msg;
    }
    // 入力値で再描画
    $row = [
      'id'         => $id,
      'name'       => $name,
      'slug'       => $slug,
      'is_active'  => $is_active ? 1 : 0,
      'created_at' => $row['created_at'] ?? '',
    ];
  }
}
?><!doctype html>
<html lang="ja">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>カテゴリ編集｜Template Party CMS</title>
  <link rel="stylesheet" href="<?= h(asset_url('/admin/assets/admin.css', true)) ?>">
</head>
<body class="admin">
<?php include __DIR__ . '/_header.php'; ?>

<div id="container">
  <h1>カテゴリ編集</h1>

  <?php if ($err !== ''): ?>
    <div class="admin-alert error"><?= h($err) ?></div>
  <?php endif; ?>

  <?php if ($row): ?>
    <form method="post" action="./category_edit.php?id=<?= (int)$row['id'] ?>" class="form-block mb2rem">
    <?= csrf_input_tag() ?>
      <input type="hidden" name="_action" value="update">
      <div class="row">
        <label class="label">カテゴリ名</label>
        <input class="input" type="text" name="name" required value="<?= h((string)$row['name']) ?>">
      </div>
      <div class="row">
        <label class="label">スラッグ</label>
        <input class="input" type="text" name="slug" required pattern="^[A-Za-z0-9_-]+$" value="<?= h((string)$row['slug']) ?>">
        <p class="small">英数字・ハイフン・アンダースコアのみ</p>
      </div>
      <div class="row">
        <label class="checkbox"><input type="checkbox" name="is_active" <?= ((int)$row['is_active'] === 1) ? 'checked' : '' ?>> 公開する</label>
      </div>
        <button type="submit" class="btn1 mb1rem">保存する</button>
        <p><a href="./categories.php">一覧に戻る</a></p>
    </form>
  <?php endif; ?>
</div>

<script src="<?= h(asset_url('/admin/assets/admin.js', true)) ?>"></script>
</body>
</html>
