<?php
declare(strict_types=1);

require_once __DIR__ . '/helpers.php';
require_once __DIR__ . '/db.php';
require_once __DIR__ . '/auth/_auth.php';

// -------- ボット/管理者/重複などの簡易フィルタ --------
$ua = (string)($_SERVER['HTTP_USER_AGENT'] ?? '');
$uaLower = strtolower($ua);
$uaBlocked = [
  'bot','crawler','spider','headless',
  'facebookexternalhit','twitterbot','slackbot','line-poker','bingpreview'
];
foreach ($uaBlocked as $bad) {
  if (strpos($uaLower, $bad) !== false) {
    http_response_code(204); exit; // カウントせず終了
  }
}
// SNSプレビュー用途など（ヘッダで弾く）
$hdrs = array_change_key_case($_SERVER, CASE_UPPER);
if (!empty($hdrs['HTTP_PURPOSE']) || !empty($hdrs['HTTP_X_PURPOSE']) || !empty($hdrs['HTTP_SEC_PURPOSE'])) {
  http_response_code(204); exit;
}
// 自分（管理者）は除外
if (auth_is_logged_in()) { http_response_code(204); exit; }

// item_id
$itemId = (int)($_POST['id'] ?? $_GET['id'] ?? 0);
if ($itemId <= 0) { http_response_code(400); exit; }

// セッション重複（同一セッション×同一アイテムは1回）
if (session_status() !== PHP_SESSION_ACTIVE) { session_start(); }
if (!isset($_SESSION['_tpcms_viewed'])) $_SESSION['_tpcms_viewed'] = [];
$k = 'i'.$itemId;
if (!empty($_SESSION['_tpcms_viewed'][$k])) {
  http_response_code(204); exit; // 既に記録済み
}
$_SESSION['_tpcms_viewed'][$k] = 1;

// -------- 記録（1日単位でUPSERT） --------
$pdo = db();
$pdo->exec('CREATE TABLE IF NOT EXISTS item_views_daily (
  item_id   INTEGER NOT NULL,
  ymd       TEXT    NOT NULL,
  count     INTEGER NOT NULL DEFAULT 0,
  PRIMARY KEY (item_id, ymd)
)');
$ymd = date('Y-m-d');

// 古い SQLite でも動くように UPSERT を手動実装
$st = $pdo->prepare('UPDATE item_views_daily
                     SET count = count + 1
                     WHERE item_id = ? AND ymd = ?');
$st->execute([$itemId, $ymd]);

if ($st->rowCount() === 0) {
    $stIns = $pdo->prepare('INSERT INTO item_views_daily (item_id, ymd, count)
                            VALUES (?, ?, 1)');
    $stIns->execute([$itemId, $ymd]);
}

http_response_code(204); // 返却は空でOK
