<?php
declare(strict_types=1);

require_once __DIR__ . '/../helpers.php';
require_once __DIR__ . '/../auth/_auth.php';
require_once __DIR__ . '/../app/categories.php';

// 未ログインならログインへ
auth_require_login();

?><!doctype html>
<html lang="ja">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>ダッシュボード｜Template Party CMS</title>
  <link rel="stylesheet" href="<?= h(asset_url('/admin/assets/admin.css', true)) ?>">
</head>
<body class="index">
<?php include __DIR__ . '/_header.php'; ?>
<div id="container">
  <h1>ダッシュボード</h1>
  <h2>設定</h2>
  <nav class="menu mb3rem">
    <ul>
      <li><a href="<?= h(url_for('/admin/news.php')) ?>">お知らせ</a></li>
      <li><a href="<?= h(url_for('/admin/categories.php')) ?>">カテゴリ設定</a></li>
      <li><a href="<?= h(url_for('/admin/settings.php')) ?>">フォーム設定</a></li>
      <li><a href="<?= h(url_for('/admin/site_settings.php')) ?>">NEW/UPアイコン・特集の設定</a></li>
      <li><a href="<?= h(url_for('/admin/csv.php')) ?>">CSV 入出力</a></li>
    </ul>
  </nav>
  <h2>データ登録・編集</h2>
  <p class="small">上の「カテゴリ設定」で準備したカテゴリがここに追加されてデータ登録ができるようになります。</p>
  <?php
    // 並び順：categories.ord（☰の順）。ord 未導入環境でも安全にフォールバック。
    try {
      $st = db()->query('SELECT name, slug, is_active FROM categories ORDER BY COALESCE(ord, 999999) ASC, id ASC');
      $cats = $st->fetchAll(PDO::FETCH_ASSOC) ?: [];
    } catch (Throwable $e) {
      // ord カラムが未作成などの場合は従来の「新しい順」に戻す
      $cats = tpcms_cat_all(false);
    }
  ?>
  <?php if (empty($cats)): ?>
    <p>カテゴリがありません。</p>
  <?php else: ?>
  <nav class="menu">
    <ul>
      <?php foreach ($cats as $c): ?>
        <?php
          $slug     = (string)$c['slug'];
          $name     = (string)$c['name'];
          $inactive = ((int)$c['is_active'] === 1) ? '' : '（※非公開中）';
          $href     = url_for('/admin/items.php', ['category' => $slug]);
        ?>
        <li>
          <a href="<?= h($href) ?>"><?= h($name) ?>（<?= h($slug) ?>）<?= $inactive !== '' ? ' ' . h($inactive) : '' ?></a>
        </li>
      <?php endforeach; ?>
    </ul>
  </nav>
  <?php endif; ?>
</div>
  <script src="<?= h(asset_url('/admin/assets/admin.js', true)) ?>"></script>
</body>
</html>
