// 横スクロールバー
(function(){
  function enhanceTableWrap(wrap){
    if (wrap.dataset.synced === "1") return; // 二重適用防止
    wrap.dataset.synced = "1";

    // <div class="table-scroll"> を作って .table-wrap を中に移す
    const box = document.createElement('div');
    box.className = 'table-scroll';
    wrap.parentNode.insertBefore(box, wrap);
    box.appendChild(wrap);

    // 上側スクロール（ダミー）を作る
    const top = document.createElement('div');
    top.className = 'top-scroll';
    const track = document.createElement('div');
    top.appendChild(track);
    box.insertBefore(top, wrap); // テーブルの“上”に置く

    // 幅同期：wrap のスクロール幅に合わせてトラックを伸ばす
    const syncSize = () => {
      // スクロール必要か判定して表示/非表示
      const need = wrap.scrollWidth > wrap.clientWidth + 1;
      top.style.display = need ? 'block' : 'none';
      track.style.width = wrap.scrollWidth + 'px';
    };

    // スクロール位置同期（上下どちらの操作にも追従）
    const syncTopToWrap = () => { wrap.scrollLeft = top.scrollLeft; };
    const syncWrapToTop = () => { top.scrollLeft = wrap.scrollLeft; };

    top.addEventListener('scroll',  syncTopToWrap,  { passive: true });
    wrap.addEventListener('scroll', syncWrapToTop,  { passive: true });
    window.addEventListener('resize', syncSize);

    // サイズ変化監視（列増減やデータ量変化に追従）
    const ro1 = new ResizeObserver(syncSize);
    ro1.observe(wrap);
    if (wrap.firstElementChild) {
      const ro2 = new ResizeObserver(syncSize);
      ro2.observe(wrap.firstElementChild);
    }

    // 初期同期
    syncSize();
    syncWrapToTop();
  }

  // 初期化：ページ内の .table-wrap 全部に適用
  document.addEventListener('DOMContentLoaded', () => {
    document.querySelectorAll('.table-wrap').forEach(enhanceTableWrap);
  });

  // 後から .table-wrap が追加される場合に備えて（任意）
  const mo = new MutationObserver(muts => {
    muts.forEach(m => {
      m.addedNodes.forEach(node => {
        if (!(node instanceof HTMLElement)) return;
        if (node.matches?.('.table-wrap')) enhanceTableWrap(node);
        node.querySelectorAll?.('.table-wrap').forEach(enhanceTableWrap);
      });
    });
  });
  mo.observe(document.documentElement, { childList: true, subtree: true });
})();


// title を 900px 未満のときだけ 14文字にカット（リアルタイム切替）
(() => {
  const MAX = 14;
  const mql = window.matchMedia('(max-width: 899.98px)');

  function clipOne(td) {
    const target = td.querySelector('a') || td;              // aがあればa、なければtd
    // 元テキストを一度だけ保存（復元用）
    if (!target.dataset.full) {
      const fullNow = (target.textContent || '').trim();
      if (fullNow) target.dataset.full = fullNow;
    }
    const full = target.dataset.full || '';
    const chars = Array.from(full);                           // 絵文字対応
    if (chars.length > MAX) {
      target.textContent = chars.slice(0, MAX).join('') + '…';
      td.setAttribute('title', full);                         // ホバーで全文
      td.dataset.clipped = '1';
    } else {
      td.removeAttribute('title');
      td.dataset.clipped = '0';
    }
  }

  function unclipOne(td) {
    const target = td.querySelector('a') || td;
    // 途中で内容が変わっていた場合に備えて、clippedでないときは現行テキストを保存し直す
    if (td.dataset.clipped !== '1') {
      const now = (target.textContent || '').trim();
      if (now) target.dataset.full = now;
    }
    const full = target.dataset.full;
    if (full && td.dataset.clipped === '1') {
      target.textContent = full;
    }
    td.removeAttribute('title');
    td.dataset.clipped = '0';
  }

  function updateAll() {
    const small = mql.matches;
    document.querySelectorAll('.ta1 td.title').forEach(td => {
      small ? clipOne(td) : unclipOne(td);
    });
  }

  // 初期＆リアルタイム切替
  document.addEventListener('DOMContentLoaded', updateAll);
  if (mql.addEventListener) {
    mql.addEventListener('change', updateAll);
  } else {
    // 古いブラウザ向けフォールバック
    window.addEventListener('resize', updateAll);
  }
})();
